/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class ArchivedSigningCertBean
extends PanelBean
implements DataBean,
CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTSCBD";
    private static final String TRACE_MASKF = "XCRTSCBF";
    private static final String TRACE_MASKT = "XCRTSCBT";
    private ServerCert certificate = null;
    private ItemDescriptor[][] m_idArchivedSigningCertTable;
    private ColumnDescriptor[] m_cdArchivedSigningCertTableStructure;
    private int[] m_iArchivedSigningCertTableSelection;

    public ArchivedSigningCertBean(ServerCert certificate, String name) {
        this.certificate = certificate;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->ArchivedSigningCertMgtBean(" + certificate + ", " + name + ")");
    }

    public void setArchivedSigningCertTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setArchivedSigningCertTableSelection(...)");
        this.m_iArchivedSigningCertTableSelection = selected;
    }

    public int[] getArchivedSigningCertTableSelection() {
        Trace.trace(TRACE_MASKT, "<->getArchivedSigningCertTableSelection() returning " + this.m_iArchivedSigningCertTableSelection);
        return this.m_iArchivedSigningCertTableSelection;
    }

    public void setArchivedSigningCertTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setArchivedSigningCertTableRowAt(" + index + ", ...)");
        this.m_idArchivedSigningCertTable[index] = items;
    }

    public ItemDescriptor[] getArchivedSigningCertTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "<->getArchivedSigningCertTableRowAt(" + index + ") returning " + this.m_idArchivedSigningCertTable[index]);
        return this.m_idArchivedSigningCertTable[index];
    }

    public int getArchivedSigningCertTableRowCount() {
        if (this.certificate == null) {
            return 0;
        }
        return 7;
    }

    public int getArchivedSigningCertTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getArchivedSigningCertTableRowStructure() {
        return this.m_cdArchivedSigningCertTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.initializeTable();
    }

    public void save() {
    }

    private void initializeTable() {
        this.m_idArchivedSigningCertTable = this.certificate == null ? new ItemDescriptor[0][0] : CertMgtPanelUtils.createCertTable(this.certificate);
        this.m_cdArchivedSigningCertTableStructure = new ColumnDescriptor[0];
        this.m_iArchivedSigningCertTableSelection = new int[0];
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        UserTaskManager utm = null;
        CertPrincipal principalToSend = null;
        Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        if (event != null) {
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            utm = this.getUserTaskManager();
            if (actionCommand.equals("ArchivedSigningCertActionsMenu.ViewArchivedSigningCertificateMenuItem")) {
                principalToSend = this.certificate.getIssuerX500Principal();
                CertMgtPanelUtils.sendTaskletRequest("ArchivedServerCertActionsMenu.ViewArchivedSigningCertificateMenuItem", principalToSend, this);
            } else if (elementName.equals("CloseButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }
}

